const { DataTypes } = require('sequelize');
const { sequelize } = require('../db/postgres');

const Votes = sequelize.define('Votes', {
  memberno: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      len: [1, 3], // Adjust based on actual memberno length
    },
    references:{
      model:  'Voters',
      key: 'memberno'
    }
  },
  candidateid: {
    type: DataTypes.INTEGER,
    allowNull: false,
       references:{
      model:  'Candidates',
      key: 'id'
    }
  },
  positionid: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references:{
      model:  'Position',
      key: 'id'
    }
  },
  created_date: {
    type: DataTypes.STRING,
  },
  updated_date: {
    type: DataTypes.STRING,
  },
}, {
  tableName: 'Votes',
  indexes: [
    {
      unique: true,
      fields: ['memberno', 'positionid'] // One vote per position per member
    }
  ]
});

module.exports = Votes;
