const { DataTypes } = require('sequelize');
const {sequelize, connect} = require('../db/postgres');
const Voters = sequelize.define('Voters', {
memberno: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
        len: [1, 3],
    },
    },
  membername: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      len: [3, 80],
    },
  },
  mobile: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
      len: [10, 12],
    },
  },
  idnum: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
      len: [7, 8],
    },
  },
  created_date: {
    type: DataTypes.STRING,
  },
  updated_date: {
    type: DataTypes.STRING,
  },
});
module.exports = Voters;
