const { DataTypes } = require('sequelize');
const {sequelize, connect} = require('../db/postgres');
const User = sequelize.define('User', {
  firstname: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      len: [3, 80],
    },
  },
  secondname: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      len: [3, 80],
    },
  },
  username: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      len: [4],
    },
  },
  password: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      len: [8],
    },
  },
  mobile: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
      len: [10, 12],
    },
  },
  role: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  created_date: {
    type: DataTypes.STRING,
  },
  updated_date: {
    type: DataTypes.STRING,
  },
  otp: {
    type: DataTypes.INTEGER,
  },
  expires: {
    type: DataTypes.STRING,
  },
});

module.exports = User;
