const { DataTypes } = require('sequelize');
const {sequelize, connect} = require('../db/postgres');
const Position = sequelize.define('Position', {
  positionname: {
    type: DataTypes.STRING,
    allowNull: false,
    validate: {
      len: [3, 80],
    },
  },
  positiondesc: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
      len: [5, 100],
    },
  }
},
{
  tableName: 'Position'  // <-- explicitly set table name
}
);

module.exports = Position;
