const Voter = require('./voters');
const Candidates = require('./candidates');
const Position = require('./positions')
const Vote = require('./votes')

// Define associations here
Voter.hasMany(Candidates, { foreignKey: 'memberno', sourceKey: 'memberno' });
Candidates.belongsTo(Voter, { foreignKey: 'memberno', targetKey: 'memberno' });


// Position-Candidates association

Position.hasMany(Candidates, { foreignKey: 'positionid'}); // Sequelize will default to targetKey: 'id'
Candidates.belongsTo(Position, { foreignKey: 'positionid'}); // Same here

Voter.hasMany(Vote, { foreignKey: 'memberno', sourceKey: 'memberno' });
Vote.belongsTo(Voter, { foreignKey: 'memberno', targetKey: 'memberno' });

Candidates.hasMany(Vote, { foreignKey: 'candidateid' });
Vote.belongsTo(Candidates, { foreignKey: 'candidateid' });

Position.hasMany(Vote, { foreignKey: 'positionid' });
Vote.belongsTo(Position, { foreignKey: 'positionid' });

module.exports = { Voter, Candidates, Position,Vote };
