const { DataTypes } = require('sequelize');
const {sequelize, connect} = require('../db/postgres');
const Candidates = sequelize.define('Candidates', {
memberno: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
        len: [1, 3],
    },
    references:{
      model:  'Voters',
      key: 'memberno'
    }
    },
 
  positionid: {
    type: DataTypes.INTEGER,
    allowNull: false,
    validate: {
      len: [1, 2],
    },
    references:{
      model:  'Position',
      key: 'id'
    }
  },
  memberphoto: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true,
    validate: {
      len: [3, 100],
    },
  },
  created_date: {
    type: DataTypes.STRING,
  },
  updated_date: {
    type: DataTypes.STRING,
  },
},
{
  tableName: 'Candidates'  // <-- explicitly set table name
}
);
module.exports = Candidates;
