const multer = require('multer');
const path = require('path');

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, 'uploads/');
  },
  filename: (req, file, cb) => {
    const parsed = path.parse(file.originalname);
    const baseName = parsed.name.replace(/\s+/g, '-').toLowerCase();
    const ext = parsed.ext;
    cb(null, baseName+ext);
  }
});

const upload = multer({ storage });

module.exports = upload;
