const {Voter,Candidates, Position, Vote} = require('../../postmodels/index');
const { fn, col } = require('sequelize');

const vote = async (req, res) => {
  try {
   const { memberno, candidateid, positionid } = req.body;
   const date = new Date().toLocaleString();
    const alreadyVoted = await Vote.findOne({
    where: { memberno, positionid }
    });
    if (alreadyVoted) {
    return res.status(200).json({ msg: "You have already voted for this position.", statusCode: "4002"  });
    }
    // Save the vote
    const voted = await Vote.create({
    memberno: memberno,
    candidateid:candidateid,
    positionid: positionid,
    updated_date: date,
    created_date: date,
    });
    if (voted) {
          res.status(201).json({ msg: "Vote cast successfull", statusCode: "4000"});
        } else {
          res.status(200).json({ msg: "Failed to cast vote", statusCode: "4001" });
        }
  } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
  }
};
const votes=  async (req, res) => {
        try {
        const allvotes = await Vote.findAll({attributes:["memberno",'candidateid','positionid'],
        include: [
            { model: Voter, attributes: ['membername'] },
            { model: Candidates, attributes: ['id','memberno'] },
            { model: Position, attributes: ['positionname'] }
        ]
        });

        if (allvotes.length === 0) {
            res.status(200).json({ msg: "No votes found", statusCode: "4001" });
        } else {
            res.status(200).json({ msg: "votes details fetched successfully", statusCode: "4000", data: allvotes });
        }
  } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
  }
};

const turnout= async(req, res) => {
    try {       
    const results = await Vote.findAll({
    attributes: [
        'candidateid',
        [fn('COUNT', col('Votes.id')), 'totalVotes']
    ],
    include: [
        {
        model: Candidates,
        attributes: ['id'],
        include: [
            {
            model: Voter,
            attributes: ['membername']
            },
            {
            model: Position,
            attributes: ['positionname']
            }
        ]
        }
    ],
    group: ['candidateid', 'Candidate.id', 'Candidate->Voter.id', 'Candidate->Position.id'],
    order: [[fn('COUNT', col('Votes.id')), 'DESC']] // optional: show top voted first
    });
    if (results.length === 0) {
        res.status(200).json({ msg: "No votes found", statusCode: "4001" });
    }else{
      res.status(200).json({ msg: "Turnout details fetched successfully", statusCode: "4000", data: results });  
    }
    } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
    }
}

module.exports = {turnout, vote, votes};
