const Voter = require('../../postmodels/voters');
const createMember = async (req, res) => {
  try {
    const memberno = req.body.memberno;
    const idnum=req.body.idnum;
    let mobile = req.body.mobile;
    mobile = "254" + mobile.slice(-9);
    const memberExists = await Voter.findOne({ where: { memberno } });
    if (!memberExists) {
      const checkId = await Voter.findOne({ where: { idnum } });
      if (!checkId) {
        const date = new Date().toLocaleString();
        const newMember = await Voter.create({
          memberno: req.body.memberno,
          membername: req.body.membername,
          idnum: req.body.idnum,
          mobile: mobile,
          updated_date: date,
          created_date: date,
        });

        if (newMember) {
          res.status(201).json({ msg: "Member added successfully", statusCode: "4000" });
        } else {
          res.status(200).json({ msg: "Failed to add member account", statusCode: "4001" });
        }
      } else {
        res.status(200).json({ msg: "A member with this ID number already exists", statusCode: "4001" });
      }
    } else {
      res.status(200).json({ msg: "A member with this ID number already exists", statusCode: "4001" });
    }
  } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
  }
};


const allMembers = async (req, res) => {
    try {
      const users = await Voter.findAll();
  
      if (users.length === 0) {
        res.status(200).json({ msg: "No members found", statusCode: "4001" });
      } else {
        res.status(200).json({ msg: "Members details fetched successfully", statusCode: "4000", data: users });
      }
    } catch (error) {
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };
  const singleMember = async (req, res) => {
    try {
      const { memberno } = req.body;
  
      const user = await Voter.findOne({ where: { memberno } });
  
      if (!user) {
        res.status(200).json({ msg: `No member with number ${memberno} found`, statusCode: "4002" });
      } else {
        res.status(200).json({ msg: "Member fetched successfully", statusCode: "4000", data: user });
      }
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

const updateMember = async (req, res) => {
  try {
    const { id, membername, memberno, mobile, idnum } = req.body;

    // Check if the user exists
    const member = await Voter.findByPk(id);

    if (!member) {
      res.status(200).json({ msg: `No member with id ${id} found`, statusCode: "4002" });
      return;
    }

    const updateObject = {};

    if (membername) {
      updateObject.membername = membername;
    }

    if (idnum) {
      updateObject.idnum = idnum;
    }

    if (memberno) {
      updateObject.memberno = memberno;
    }

    if (mobile) {
      updateObject.mobile = mobile;
    }

    updateObject.updated_date = new Date().toLocaleString();

    // Update the user
    await member.update(updateObject);

    res.status(200).json({ msg: "Member updated successfully", statusCode: "4000" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: error.message || "An error occurred" });
  }
};

 
const deleteMember = async (req, res) => {
    try {
      const { id } = req.body;
  
      // Check if the user exists
      const member = await Voter.findByPk(id);
  
      if (!member) {
        res.status(200).json({ msg: `No member with id ${id} found`, statusCode: "4002" });
        return;
      }
  
      // Delete the user
      await member.destroy();
  
      res.status(200).json({ msg: "Member Deleted successfully", statusCode: "4000" });
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

module.exports = {allMembers, singleMember, updateMember,deleteMember,createMember};