const User = require('../../postmodels/users');
const bcrypt = require('bcrypt');
const createUserPost = async (req, res) => {
  try {
    const username = req.body.username;
    let mobile = req.body.mobile;
    mobile = "254" + mobile.slice(-9);

    const userExists = await User.findOne({ where: { username } });
    if (!userExists) {
      const checkMobile = await User.findOne({ where: { mobile } });

      if (!checkMobile) {
        const salt = await bcrypt.genSalt(10);
        const hash = await bcrypt.hash(req.body.password, salt);

        const date = new Date().toLocaleString();
        const newUser = await User.create({
          username: req.body.username,
          password: hash,
          role: req.body.role,
          firstname: req.body.firstname,
          secondname: req.body.secondname,
          mobile: mobile,
          updated_date: date,
          created_date: date,
        });

        if (newUser) {
          res.status(201).json({ msg: "User account created successfully", statusCode: "4000" });
        } else {
          res.status(200).json({ msg: "Failed to create user account", statusCode: "4001" });
        }
      } else {
        res.status(200).json({ msg: "A user with this mobile number already exists", statusCode: "4001" });
      }
    } else {
      res.status(200).json({ msg: "A user with this username already exists", statusCode: "4001" });
    }
  } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
  }
};

const loginPost = async (req, res) => {
    try {
      const { username, password } = req.body;
  
      // Find the user by username
      const user = await User.findOne({ where: { username } });
  
      if (!user) {
        res.status(200).json({ msg: "Wrong username", statusCode: "4001" });
        return;
      }
  
      const hashedPassword = user.password;
  
      // Compare passwords
      bcrypt.compare(password, hashedPassword, (err, result) => {
        if (err) {
          res.status(500).json({ msg: "A problem occurred when trying to login", statusCode: "4001", body: err });
        } else if (result) {
          const { role, username: userId, id } = user;
          res.status(200).json({ msg: "Login success", statusCode: "4000", body: [{ username: userId }, { role }, { id }] });
        } else {
          res.status(200).json({ msg: "Wrong password", statusCode: "4001" });
        }
      });
    } catch (error) {
      console.error(error);
      res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
    }
  };
const allUsers = async (req, res) => {
    try {
      const users = await User.findAll();
  
      if (users.length === 0) {
        res.status(200).json({ msg: "No users found", statusCode: "4001" });
      } else {
        res.status(200).json({ msg: "Users details fetched successfully", statusCode: "4000", data: users });
      }
    } catch (error) {
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };
  const singleUser = async (req, res) => {
    try {
      const { username } = req.body;
  
      const user = await User.findOne({ where: { username } });
  
      if (!user) {
        res.status(200).json({ msg: `No member with username ${username} found`, statusCode: "4002" });
      } else {
        res.status(200).json({ msg: "Member fetched successfully", statusCode: "4000", data: user });
      }
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

const updateUser = async (req, res) => {
  try {
    const { id, firstname, secondname, username, mobile, role,password } = req.body;

    // Check if the user exists
    const user = await User.findByPk(id);

    if (!user) {
      res.status(200).json({ msg: `No user with id ${id} found`, statusCode: "4002" });
      return;
    }

    const updateObject = {};

    if (firstname) {
      updateObject.firstname = firstname;
    }

    if (secondname) {
      updateObject.secondname = secondname;
    }

    if (username) {
      updateObject.username = username;
    }

    if (mobile) {
      updateObject.mobile = mobile;
    }

    if (role) {
      updateObject.role = role;
    }

    if (password) {
      const salt = await bcrypt.genSalt(10);
      const hash = await bcrypt.hash(password, salt);
      updateObject.password = hash;
    }

    updateObject.updated_date = new Date().toLocaleString();

    // Update the user
    await user.update(updateObject);

    res.status(200).json({ msg: "User updated successfully", statusCode: "4000" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: error.message || "An error occurred" });
  }
};

 
const deleteUser = async (req, res) => {
    try {
      const { id } = req.body;
  
      // Check if the user exists
      const user = await User.findByPk(id);
  
      if (!user) {
        res.status(200).json({ msg: `No user with id ${id} found`, statusCode: "4002" });
        return;
      }
  
      // Delete the user
      await user.destroy();
  
      res.status(200).json({ msg: "Member Deleted successfully", statusCode: "4000" });
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

module.exports = {allUsers, singleUser, updateUser,deleteUser,createUserPost,loginPost};