const Position = require('../../postmodels/positions');
const createPosition = async (req, res) => {
  try {
    const positionname = req.body.positionname.toLowerCase();
  
    const positionExists = await Position.findOne({ where: { positionname } });
    if (!positionExists) {
        const date = new Date().toLocaleString();
        const newPosition = await Position.create({
          positionname: positionname,
          positiondesc: req.body.positiondesc,
          updated_date: date,
          created_date: date,
        });

        if (newPosition) {
          res.status(201).json({ msg: "Position added successfully", statusCode: "4000" });
        } else {
          res.status(200).json({ msg: "Failed to add position", statusCode: "4001" });
        }
    
    } else {
      res.status(200).json({ msg: "A position with this name already exists", statusCode: "4001" });
    }
  } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
  }
};


const allPositions = async (req, res) => {
    try {
      const positions = await Position.findAll();
  
      if (positions.length === 0) {
        res.status(200).json({ msg: "No positions found", statusCode: "4001" });
      } else {
        res.status(200).json({ msg: "Positions details fetched successfully", statusCode: "4000", data: positions });
      }
    } catch (error) {
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };
  const singlePosition = async (req, res) => {
    try {
      const { id } = req.body;
  
      const position = await Position.findOne({ where: { id } });
  
      if (!position) {
        res.status(200).json({ msg: `No position with ID ${id} found`, statusCode: "4002" });
      } else {
        res.status(200).json({ msg: "Position fetched successfully", statusCode: "4000", data: position });
      }
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

const updatePosition = async (req, res) => {
  try {
    const { id, positionname, positiondesc} = req.body;

    // Check if the user exists
    const position = await Position.findByPk(id);

    if (!position) {
      res.status(200).json({ msg: `No position with id ${id} found`, statusCode: "4002" });
      return;
    }

    const updateObject = {};

    if (positionname) {
      updateObject.positionname = positionname;
    }

    if (positiondesc) {
      updateObject.positiondesc = positiondesc;
    }

    updateObject.updated_date = new Date().toLocaleString();
    
    // Update the user
    await position.update(updateObject);

    res.status(200).json({ msg: "Position updated successfully", statusCode: "4000" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: error.message || "An error occurred" });
  }
};

 
const deletePosition = async (req, res) => {
    try {
      const { id } = req.body;
  
      // Check if the user exists
      const position = await Position.findByPk(id);
  
      if (!position) {
        res.status(200).json({ msg: `No position with id ${id} found`, statusCode: "4002" });
        return;
      }
  
      // Delete the user
      await position.destroy();
  
      res.status(200).json({ msg: "Position Deleted successfully", statusCode: "4000" });
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

module.exports = {allPositions, singlePosition, updatePosition,deletePosition,createPosition};