
const {Voter,Candidates, Position} = require('../../postmodels/index');
const { all } = require('../../routes/positions');

const createCandidate = async (req, res) => {
  try {
    const file = req.file;
    const memberno = req.body.memberno;
    const memberExists = await Voter.findOne({ where: { memberno } });
    if (memberExists) {
    const candidateExists = await Candidates.findOne({ where: { memberno } });
    if (!candidateExists) {
        const date = new Date().toLocaleString();
        const newCandidate = await Candidates.create({
          memberno: memberno,
          positionid: req.body.positionid,
          memberphoto: file.filename,
          updated_date: date,
          created_date: date,
        });

        if (newCandidate) {
          res.status(201).json({ msg: "Candidate added successfully", statusCode: "4000" });
        } else {
          res.status(200).json({ msg: "Failed to add candidate", statusCode: "4001" });
        }
    
    } else {
      res.status(200).json({ msg: "A candidate with this number already exists", statusCode: "4001" });
    }

    }else {
        res.status(200).json({ msg: "A member with this number number does not exists", statusCode: "4001" });
      }
    
  } catch (error) {
    console.error(error);
    res.status(500).json({ msg: "An error occurred, please try again later", statusCode: "5000" });
  }
};


const allCandidates = async (req, res) => {
    try {
      const candidates = await Candidates.findAll({ include: [
                  {
                    model: Voter,
                    attributes: ['membername', 'memberno', 'idnum']
                  },
                  {
                    model: Position,
                    attributes: ['positionname', 'positiondesc']
                  }
                ]});
      if (candidates.length === 0) {
        res.status(200).json({ msg: "No candidates found", statusCode: "4001" });
      } else {
        res.status(200).json({ msg: "Candidates details fetched successfully", statusCode: "4000", data: candidates });
      }
    } catch (error) {
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };
const singleCandidate= async (req, res) => {
    try {
      const { memberno } = req.body;
      const candidate = await Candidates.findOne({ where: { memberno },
         include: [
                  {
                    model: Voter,
                    attributes: ['membername', 'memberno', 'idnum']
                  },
                  {
                    model: Position,
                    attributes: ['positionname', 'positiondesc']
                  }
                ]
         });
  
      if (!candidate) {
        res.status(200).json({ msg: `No Candidate with member number ${memberno} found`, statusCode: "4002" });
      } else {
        res.status(200).json({ msg: "Candidate fetched successfully", statusCode: "4000", data: candidate });
      }
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

const updateCandidate = async (req, res) => {
  try {
    const { id, positionid, memberno} = req.body;
    const file=req.file;

    // Check if the user exists
    const candidate = await Candidates.findByPk(id);

    if (!candidate) {
      res.status(200).json({ msg: `No candidate with id ${id} found`, statusCode: "4002" });
      return;
    }
    const updateObject = {};

    if (positionid) {
      updateObject.positionid = positionid;
    }

    if (memberno) {
      updateObject.memberno = memberno;
    }
    if (file) {
      if (file.filename) {
        updateObject.memberphoto= file.filename
    }
    }
    updateObject.updated_date = new Date().toLocaleString();
    // Update the user
    await candidate.update(updateObject);
    res.status(200).json({ msg: "Candidate updated successfully", statusCode: "4000" });
  } catch (error) {
    console.error(error);
    res.status(500).json({ error: error.message || "An error occurred" });
  }
};

 
const deleteCandidate= async (req, res) => {
    try {
      const { id } = req.body;
  
      // Check if the user exists
      const candidate = await Candidates.findByPk(id);
  
      if (!candidate) {
        res.status(200).json({ msg: `No candidate with id ${id} found`, statusCode: "4002" });
        return;
      }
  
      // Delete the user
      await candidate.destroy();
  
      res.status(200).json({ msg: "Candidate Deleted successfully", statusCode: "4000" });
    } catch (error) {
      console.error(error);
      res.status(500).json({ error: error.message || "An error occurred" });
    }
  };

module.exports = {allCandidates, singleCandidate, updateCandidate,deleteCandidate,createCandidate};