require('dotenv').config();
const express = require('express');
const app = express();
const cors = require('cors');
const path = require('path');
const multer = require('multer');
const basicAuth = require('express-basic-auth');
const userRouter = require('./routes/users');
const memberRouter = require('./routes/voters');
const positionRouter = require('./routes/positions');
const candidateRouter = require('./routes/candidates')
const voteRouter = require('./routes/votes')
const {sequelize, connect} = require('./db/postgres')
app.use(express.urlencoded({ extended: true }));
app.use(express.json());
app.use(express.static(path.join(__dirname, 'public')));
app.use('/uploads', express.static(path.join(__dirname, './uploads')));
const corsOptions ={
  origin: ['http://192.168.106.44:8080','http://localhost:8080'], // Replace with your frontend URL
  methods: 'GET,HEAD,PUT,PATCH,POST,DELETE',
  credentials: true,
  optionsSuccessStatus: 200
}

app.use(cors());
app.use(basicAuth({
    authorizer: (username, password,cb) =>{
        const userMatches = basicAuth.safeCompare(username, process.env.MY_SECRET_USERNAME)
        const passwordMatches = basicAuth.safeCompare(password,process.env.MY_SECRET_PASSWORD)
        if (userMatches & passwordMatches) {
            return cb(null, true)
        } else {
           return cb(null, false) 
        } 
    },
    authorizeAsync:true
}));
app.use((req, res, next)=>{
    const router_id= req.headers['x-router-id']
    const source_system = req.headers['x-source-system']
    if (source_system === process.env.SOURCE_SYSTEM && router_id === process.env.ROUTER_ID) {
        next()
    } else {
        res.status(401).json({msg:"Unauthorized requests",statusCode:"4001"})
    }
});


app.use('/user/v1/', cors(corsOptions), userRouter);
app.use('/member/v1/', cors(corsOptions), memberRouter);
app.use('/position/v1/', cors(corsOptions), positionRouter);
app.use('/candidate/v1/', cors(corsOptions), candidateRouter);
app.use('/vote/v1/',cors(corsOptions),voteRouter);

const PORT = process.env.PORT || 8080;
const start = async()=>{
    // Sync the defined model with the database
    sequelize.sync({ alter: true }) // This will ensure the model matches the database structure
    .then(() => {
    console.log('Model synced successfully.');
    })
    .catch((error) => {
    console.error('Error syncing model:', error);
    });

    app.listen(PORT, ()=>{
        console.log(`Server listening to port ${PORT} ...`);
    })
} 

start()